/* ***************************************************************************************
 * FILE:          ButtonGroupWidget2D.h
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ButtonGroupWidget2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#if !defined(ButtonGroupWidget2D_h)
#define ButtonGroupWidget2D_h

#include <Widgets/2D/ButtonGroup/generated/ButtonGroupWidget2DBase.h>

class ButtonWidget2D;

/*****************************************************************************/
/* ButtonGroupWidget2D provides support for option groups in which maximum one button is active.
 * This a delegate widget and its behaviour is implemented by a widget controller.
 */
/*****************************************************************************/
class ButtonGroupWidget2D : public ButtonGroupWidget2DBase
{
   public:
      ButtonGroupWidget2D();
      virtual ~ButtonGroupWidget2D();

      CGI_WIDGET_RTTI_DECLARATION(ButtonGroupWidget2D, ButtonGroupWidget2DBase);

      // overrides from ControlTemplateCloneableWidget
      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap) override;

      // overrides from DelegateWidget
      virtual hmibase::widget::WidgetController* GetDefaultController() const override;

      virtual bool findButtons(std::vector<ButtonWidget2D*>& buttons);

      CdaWidget2DDef(ButtonGroupWidget2D, ButtonGroupWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif // ButtonGroupWidget2D_h
