/* ***************************************************************************************
* FILE:          ToggleButton2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ToggleButton2D.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ToggleButton2D_h)
#define ToggleButton2D_h

#include <Widgets/2D/Adorner/DefaultAdorner.h>
#include <View/CGI/CgiExtensions/AnimationWrapper.h>

class AppViewHandler;


/*****************************************************************************/
struct ToggleButtonAdornerData
{
   /*****************************************************************************/
   ToggleButtonAdornerData() : LeftNode(NULL), RightNode(NULL)
   {
   }

   ~ToggleButtonAdornerData()
   {
      LeftNode = NULL;
      RightNode = NULL;
   }

   /*****************************************************************************/
   Candera::Node2D* LeftNode;
   Candera::Node2D* RightNode;
   Candera::Vector2 AdornerSize;
   Candera::Rectangle GroupBounds;
};


/*****************************************************************************/
class ToggleButtonAdornerAnimation : public hmibase::widget::adorner::DefaultAdornerAnimation
{
      FEATSTD_TYPEDEF_BASE(hmibase::widget::adorner::DefaultAdornerAnimation);

   public:
      CANDERA_RTTI_DECLARATION(ToggleButtonAdornerAnimation);

      /*****************************************************************************/
      ToggleButtonAdornerAnimation(AppViewHandler& appViewHandler);

      /*****************************************************************************/
      virtual bool attachToAdorner(hmibase::widget::adorner::Adorner::SharedPointer adorner);
      virtual void detachFromAdorner();
      virtual bool start();

   protected:
      ::hmibase::view::AnimatedPropertyWrapper _leftNodeAnimatedProperty;
      ::hmibase::view::AnimatedPropertyWrapper _rightNodeAnimatedProperty;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ToggleButtonAdornerAnimation);
};


/*****************************************************************************/
class ToggleButtonAdornerManager : public hmibase::widget::adorner::DefaultAdornerManager
{
      typedef DefaultAdornerManager Base;

   public:
      /*****************************************************************************/
      ToggleButtonAdornerManager();

      /*****************************************************************************/
      enum enToggleSide
      {
         UndefSide,
         LeftSide,
         RightSide
      };

      static enToggleSide getSideForPosition(hmibase::widget::adorner::Adorner::SharedPointer adorner, const Candera::Vector2& position);
      static enToggleSide getCurrentSide(hmibase::widget::adorner::Adorner::SharedPointer adorner);

      /*****************************************************************************/
      virtual hmibase::widget::adorner::Adorner::SharedPointer createAdorner(Candera::Widget2D& widget, Candera::Node2D* adornerNode, Candera::Node2D* adornerContainer);
      virtual void moveAdorner(hmibase::widget::adorner::Adorner::SharedPointer adorner, const Candera::Vector2& delta);

      /*****************************************************************************/
      const std::string& getLeftNodeName() const;
      void setLeftNodeName(const std::string& name);
      const std::string& getRightNodeName() const;
      void setRightNodeName(const std::string& name);

   protected:
      virtual hmibase::widget::adorner::AdornerAnimation* newAnimation(Candera::Widget2D& widget);

      /*****************************************************************************/
      std::string _leftNodeName;
      std::string _rightNodeName;
};


#endif
