/* ***************************************************************************************
* FILE:          ButtonExtensionWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonExtensionWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef ButtonExtension_WIDGET2D_H
#define ButtonExtension_WIDGET2D_H

#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Appearance/AppearanceState.h>

namespace hmibase {
namespace widget {
namespace appearance {
class AppearanceTemplate;
}


}
}


class ButtonWidget2D;

class ButtonExtension
{
   public:
      ButtonExtension();
      virtual ~ButtonExtension();

      ButtonWidget2D* GetButtonWidget() const;
      const hmibase::widget::appearance::AppearanceState& GetButtonState() const;

   protected:
      virtual void Update(BaseWidget2D& widget);
      virtual void OnNodeChanged(Candera::Node2D* node);

      void SetInvalid(bool invalid);
      bool IsInvalid() const;

   private:
      void UpdateButtonWidget(BaseWidget2D& widget);
      void UpdateButtonState();

      bool _invalid;
      int  _ancestorSearchDone;
      ButtonWidget2D* _buttonWidget;
      hmibase::widget::appearance::AppearanceState _buttonState;
};


class ButtonExtensionWidget2D : public BaseWidget2D, public ButtonExtension
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ButtonExtensionWidget2D, BaseWidget2D);

      ButtonExtensionWidget2D();
      virtual ~ButtonExtensionWidget2D();

      virtual bool PrepareForCloning();
      virtual hmibase::widget::appearance::AppearanceTemplate* CreateAppearanceTemplate()
      {
         return NULL;
      }

   protected:
      virtual void Update();
      virtual void OnNodeChanged();

   private:
      CdaWidget2DDef(ButtonExtensionWidget2D, BaseWidget2D)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


class TextWidget2D;
class ButtonTextExtensionWidget2D : public ButtonExtensionWidget2D
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(ButtonTextExtensionWidget2D, ButtonExtensionWidget2D);

      ButtonTextExtensionWidget2D();
      virtual ~ButtonTextExtensionWidget2D();

   protected:
      virtual void Update();
      virtual void OnNodeChanged();

      TextWidget2D* GetTextWidget() const;

   private:
      void UpdateTextWidget();

      TextWidget2D* _textWidget;
      int _ancestorTextWidgetSearchDone;

      CdaWidget2DDef(ButtonTextExtensionWidget2D, ButtonExtensionWidget2D)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
};


#endif
