/* ***************************************************************************************
* FILE:          ButtonBubbleController2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonBubbleController2D.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ButtonBubbleController2D_h)
#define ButtonBubbleController2D_h

#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <Widgets/2D/Button/ButtonWidget2D.h>
#include <Widgets/2D/Adorner/DefaultAdorner.h>

/*****************************************************************************/
class ButtonBubbleController2D : public ButtonController2D
{
      FEATSTD_TYPEDEF_BASE(ButtonController2D);

   public:
      CANDERA_RTTI_DECLARATION(ButtonBubbleController2D);

      ButtonBubbleController2D(hmibase::widget::adorner::AdornerManager& adornerManager, const hmibase::widget::adorner::AdornerMarkerFilter& adornerMarkerFilter);
      virtual ~ButtonBubbleController2D();

      //overrides from WidgetController
      virtual bool OnMessage(DelegateWidget& widget, const Courier::Message& msg) override;

      //overrides from ButtonController2D
      virtual bool onReaction(ButtonWidget2D& button, enReaction reaction) override;

      enReaction getBubbleShowReaction() const
      {
         return _bubbleShowReaction;
      }
      void setBubbleShowReaction(enReaction reaction);

      bool isBubbleEnabled() const
      {
         return _bubbleEnabled;
      }
      void setBubbleEnabled(bool enabled);

      unsigned int getAdornerHideTimerTimeout() const
      {
         return _adornerHideTimerTimeout;
      }
      void setAdornerHideTimerTimeout(unsigned int timeout);

   protected:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(ButtonBubbleController2D);

      virtual bool createAdorner(ButtonWidget2D& button);
      virtual void showAdorner(ButtonWidget2D& button);
      virtual void hideAdorner();

      virtual void startAdornerHideTimer();
      virtual void stopAdornerHideTimer();
      virtual void onAdornerHideTimerExpired(DelegateWidget& widget);

      hmibase::widget::adorner::AdornerManager& _adornerManager;
      hmibase::widget::adorner::AdornerMarkerFilter _adornerMarkerFilter;

      hmibase::widget::adorner::Adorner::SharedPointer _adorner;

      Util::Timer* _adornerHideTimer;
      unsigned int _adornerHideTimerTimeout;

      bool _bubbleEnabled;
      enReaction _bubbleShowReaction;
};


/*****************************************************************************/
class ButtonBubbleAdornerManager : public hmibase::widget::adorner::DefaultAdornerManager
{
      typedef hmibase::widget::adorner::DefaultAdornerManager Base;

   protected:
      virtual Candera::Node2D* prepareAdornerNodeContent(Candera::Widget2D& widget, Candera::Node2D* adornerNodeTemplate);
      virtual Candera::Rectangle calculateAdornerNodeBounds(Candera::Widget2D& widget, hmibase::widget::adorner::AdornerNode* adornerNode, Candera::Node2D* adornerNodeContent, Candera::Node2D* adornerContainer);
};


#endif
