/* ***************************************************************************************
 * FILE:          ButtonAppearance2D.cpp
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  ButtonAppearance2D is part of HMI-Base Widget Library
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#include "widget2D_std_if.h"
#include "ButtonAppearance2D.h"

#include <Widgets/2D/Button/ButtonWidget2D.h>
#include <Widgets/2D/Button/ButtonExtensionWidget2D.h>
#include <Widgets/2D/EffectControl/ColorEffectWidget2D.h>
#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_APPEARANCE
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/ButtonAppearance2D.cpp.trc.h"
#endif


namespace hmibase {
namespace widget {
namespace appearance {


/**************************************************************************/
bool ButtonAppearanceHelper::registerExtensionAppearanceTemplate(ButtonWidget2D& button, ButtonExtensionWidget2D& extensionWidget)
{
   bool result(false);
   if (extensionWidget.GetNode() != NULL)
   {
      hmibase::widget::appearance::AppearanceTemplateContainer* appTemplateContainer = button.GetOrCreateAppearanceTemplateContainer();

      if (appTemplateContainer != NULL)
      {
         const char* extensionNodeId = extensionWidget.GetNode()->GetName();
         hmibase::widget::appearance::AppearanceTemplateContainer::Entry* entry = appTemplateContainer->get(extensionNodeId);

         if (entry == NULL)
         {
            hmibase::widget::appearance::AppearanceTemplate* appTemplate = extensionWidget.CreateAppearanceTemplate();
            if (appTemplate != NULL)
            {
               ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Register appearance template for node=%50s, buttonExtension=%p button=[%p.%50s.%s]",
                                   extensionNodeId, &extensionWidget,
                                   &button, button.GetParentView() != NULL ? button.GetParentView()->GetId().CStr() : "<null>", button.GetLegacyName()));

               appTemplateContainer->add(extensionNodeId, appTemplate);
               result = true;
            }
            else
            {
               ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "No appearance template for node=%50s, buttonExtension=%p button=[%p.%50s.%s]",
                                   extensionNodeId, &extensionWidget,
                                   &button, button.GetParentView() != NULL ? button.GetParentView()->GetId().CStr() : "<null>", button.GetLegacyName()));

               appTemplateContainer->clear(extensionNodeId);
            }
         }
         else
         {
            ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Appearance template already registered for node=%50s, buttonExtension=%p button=[%p.%50s.%s]",
                                extensionNodeId, &extensionWidget,
                                &button, button.GetParentView() != NULL ? button.GetParentView()->GetId().CStr() : "<null>", button.GetLegacyName()));

            result = true;
         }
      }
   }
   return result;
}


}
}


}
