/* ***************************************************************************************
* FILE:          ButtonAnimatedReleaseController2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ButtonAnimatedReleaseController2D.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ButtonAnimatedReleaseController2D_h)
#define ButtonAnimatedReleaseController2D_h

#include "ButtonWidget2D.h"

class AnimationWidgetIndMsg;
class ButtonAnimationWidget2D;


/*****************************************************************************/
/* Attach this button controller to a button widget which has a release animation in order to have the release reaction message posted after the animation is finished.
*/
class ButtonAnimatedReleaseController2D : public ButtonController2D
{
      FEATSTD_TYPEDEF_BASE(ButtonController2D);

   public:
      CANDERA_RTTI_DECLARATION(ButtonAnimatedReleaseController2D);

      virtual ~ButtonAnimatedReleaseController2D();

      //overrides from WidgetController
      virtual bool OnMessage(DelegateWidget& widget, const Courier::Message& msg) override;

      //overrides from ButtonController2D
      virtual bool onReaction(ButtonWidget2D& button, enReaction reaction) override;

      // is the controller is disabled it will allow the release reaction to be posted immediately
      void setEnabled(bool enable)
      {
         _controllerEnabled = enable;
      }

      bool isEnabled() const
      {
         return _controllerEnabled;
      }

      //singleton instance
      static ButtonAnimatedReleaseController2D& getInstance();

   protected:
      ButtonAnimatedReleaseController2D();

      FEATSTD_MAKE_CLASS_UNCOPYABLE(ButtonAnimatedReleaseController2D);

      ButtonAnimationWidget2D* findButtonAnimation(Courier::ViewScene2D& view, Candera::Node2D& buttonNode, Courier::Identifier buttonAnimationId);

      bool onAnimationFinishedMsg(ButtonWidget2D& button, const AnimationWidgetIndMsg& animationIndMsg);

      bool _controllerEnabled;
      bool _buttonReleased;
};


#endif
