/* ***************************************************************************************
* FILE:          BusyIndicatorWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BusyIndicatorWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(BusyIndicatorWidget2D_h)
#define BusyIndicatorWidget2D_h

#include "Widgets/2D/BusyIndicator/generated/BusyIndicatorWidget2DBase.h"


/*
BusyIndicatorWidget2D is derived from AnimationPlayerListner inorder to Register
an AnimationPlayerListener to an AnimationPlaye and handle the listener's functions.
*/

#include "Scale2DPropertySetter.h"

class BusyIndicatorWidget2D : public BusyIndicatorWidget2DBase, public Candera::Animation::AnimationPlayerListener
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(BusyIndicatorWidget2D, BusyIndicatorWidget2DBase);

      BusyIndicatorWidget2D();
      ~BusyIndicatorWidget2D();

      // public member functions
      virtual void InitWidget();
      virtual void Update();
      virtual bool OnMessage(const Message& f_orfMsg);
      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);
      void OnParentViewRenderingEnabled(bool enable);

      CdaWidget2DDef(BusyIndicatorWidget2D, BusyIndicatorWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()
   protected:
      virtual void OnAnimationTimeDispatcherChanged();
      virtual void OnChanged(FeatStd::UInt32 propertyId);
   private:
      bool m_bMinimumAnimationDuration_TimerExpired;
      FeatStd::UInt8 m_u8DotArrayIndex;
      FeatStd::UInt32 m_u8IncCirNodeCount;
      FeatStd::Float* m_IncCirAnimationValues;
      Candera::Camera2D*                                       m_pCameraNode;
      Candera::Animation::AnimationController::SharedPointer   m_pAnimationController;
      Candera::Animation::AlphaNode2DPropertySetter*           m_pAlphaPS;                // ANIMATION ALPHA PROPERTY
      Candera::Animation::Scale2DPropertySetter*   m_pScalePS;                            // ANIMATION SCALE PROPERTY
      Candera::Animation::SequenceTimeType*        m_IncCirAnimationKfs;
      Candera::Node2D*                             m_pMainNode;
      Candera::Node2D*                             m_pNode;
      Candera::Animation::AnimationTimeDispatcher*          m_pAnimationTimeDispatcher;

      // Text properties
      TextWidget2D*                                             m_TextWidgetPtr;
      ::Util::Timer*                                            m_BusyIndicator_Timer;   // Timer object
      FeatStd::Float m_BusyIndicatorAnimationValues[2];
      Candera::String m_sText;
      Candera::Animation::Transformable2DRotatePropertySetter m_RotationPS;
      Candera::Animation::Transformable2DTranslateXPropertySetter m_TranslatePS;
      Candera::Animation::SequenceTimeType m_BusyIndicatorAnimationKfs[2];
      FeatStd::Internal::Vector<Candera::RenderNode*> m_ptCircularBusyIndicatorNodePtr;
      Candera::Vector2 m_pivotOffset;
      FeatStd::Internal::Vector<FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> > m_pIncCirBusyIndicatorKfs;
      FeatStd::Internal::Vector<FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> > m_pIncCirScaleKfs;
      FeatStd::Internal::Vector<FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationBlendedProperty> > m_animScaleProperty;
      FeatStd::Internal::Vector<FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationBlendedProperty> > m_animAlphaProperty;
      FeatStd::Internal::Vector<FeatStd::String> stDot;
      FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> m_pBusyIndicatorKfs;
      FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationBlendedProperty> m_pAnimProperty;
      FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> m_pAnimPlayer;

      /*	Member Functions	*/
      void InitAnimations();
      bool InitIncCirNodeInfo(); // Get the Node information for Incremental Circular Busy Indicator type
      void InitIncCirBusyIndicatorAnimation();
      void InitCirularOrHorizontalBusyIndicatorAnimation();
      void CreateIncCirKeyFrames();
      void CreateCircularBusyKeyFrames();
      void CreateHorizontalBusyKeyFrames();
      void CreateAnimationKeyFrameSequence();
      void CreateAlphaAnimationKeyFrameSequence();
      void CreateScaleAnimationKeyFrameSequence();
      void CreateAnimationProperties();
      void CreateAnimationController();
      void CreateAnimationPlayer();
      void CreateScalingAnimationProperties();
      void CreateAlphaAnimationProperties();
      void AdjustNodePivotOffset();
      void StopBusyIndicatorAnimation() ;
      void StartBusyIndicatorAnimation() ;
      void StartBusyIndicatorTimer();

      //Cda Properties

      /*This function is called when the world time has to be
      dispatched to a collection of AnimationPlayers present in a widget*/
};


#endif
