/* ***************************************************************************************
* FILE:          BaseLineLayouterWidget2D.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BaseLineLayouterWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "BaseLineLayouterWidget2D.h"

#if ((COURIER_VERSION_MAJOR > 3) || ((COURIER_VERSION_MAJOR == 3) && (COURIER_VERSION_MINOR >= 5)))
#include <Candera/EngineBase/Layout/BaseLineLayouter.h>
#else
#include <Candera/Engine2D/Layout/BaseLineLayouter.h>
#endif

#include <Widgets/2D/Common/NodeHelper.h>


#include <Trace/ToString.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_WIDGET_LAYOUTER
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/BaseLineLayouterWidget2D.cpp.trc.h"
#endif


CGI_WIDGET_RTTI_DEFINITION(BaseLineLayouterWidget2D);

BaseLineLayouterWidget2D::BaseLineLayouterWidget2D() : _invalid(true)
{
}


BaseLineLayouterWidget2D::~BaseLineLayouterWidget2D()
{
}


bool BaseLineLayouterWidget2D::CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap)
{
   bool cloned(false);
   if (Base::CloneFrom(originalWidget, controlTemplateMap))
   {
      const BaseLineLayouterWidget2D* original = CLONEABLE_WIDGET_CAST<const BaseLineLayouterWidget2D*>(originalWidget);
      if (original == NULL)
      {
         return false;
      }

      SetNestedLevel(original->GetNestedLevel());
      SetBaseLineOffset(original->GetBaseLineOffset());

      cloned = true;
   }
   return cloned;
}


void BaseLineLayouterWidget2D::Update()
{
   if (_invalid)
   {
      Candera::Node2D* node = NodeHelper::GetNestedParent(GetNode(), GetNestedLevel());
      if ((node != NULL) && !node->IsTypeOf(Candera::Scene2D::GetTypeId()))
      {
         _invalid = false;

         bool invalidate = false;
         Candera::BaseLineLayouter* layouter = dynamic_cast<Candera::BaseLineLayouter*>(node->GetLayouter());
         if (layouter == NULL)
         {
            layouter = Candera::BaseLineLayouter::Create();
            if (layouter != NULL)
            {
               ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update Set Layouter level=%u %s",
                                   GetNestedLevel(), HMIBASE_TO_STRING_VW(this)));

               node->SetLayouter(layouter);
               invalidate = true;
            }
         }

         if ((layouter != NULL) && Candera::BaseLineLayouter::GetBaseLineOffset(*node))
         {
            ETG_TRACE_USR1_DCL((APP_TRACECLASS_ID(), "Update Set BaseLineOffset offset=%.2f %s",
                                GetBaseLineOffset(), HMIBASE_TO_STRING_VW(this)));

            Candera::BaseLineLayouter::SetBaseLineOffset(*node, GetBaseLineOffset());
            invalidate = true;
         }

         if (invalidate)
         {
            ETG_TRACE_USR4_DCL((APP_TRACECLASS_ID(), "Update node=%s", HMIBASE_TO_STRING_SPN2D(GetNode())));

            InvalidateLayout();
            Invalidate();
         }
      }
   }
}


void BaseLineLayouterWidget2D::OnChanged(Courier::UInt32 propertyId)
{
   Base::OnChanged(propertyId);
   _invalid = true;
}


void BaseLineLayouterWidget2D::OnNodeChanged()
{
   _invalid = true;
   triggerUpdate();
}
