/* ***************************************************************************************
* FILE:          AnimationWidget2D.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationWidget2D is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#if !defined(AnimationWidget2D_h)
#define AnimationWidget2D_h

#include "Widgets/2D/Animation/generated/AnimationWidget2DBase.h"
#include "Candera/EngineBase/Animation/AnimationPlayerListener.h"
#include "Candera/Engine2D/AnimationPropertySetters/AlphaNode2DPropertySetter.h"
#include "Widgets/2D/ControlTemplate/ControlTemplateCloneableWidget.h"

class AnimationWidget2D : public AnimationWidget2DBase,
   public Candera::Animation::AnimationPlayerListener
   IMPLEMENTS_CLONEABLE_WIDGET
{
   public:
      CGI_WIDGET_RTTI_DECLARATION(AnimationWidget2D, AnimationWidget2DBase);

      AnimationWidget2D();
      ~AnimationWidget2D();

      /**
      * Initializes the widget so that all referred resource can be resolved
      */
      virtual void InitWidget();

      /**
      * Courier messages will be routed to this function.
      * If widget is interested in any message then, on receiving message will act accordigly.
      */
      virtual bool OnMessage(const Courier::Message& msg);

      /**
      * Invalidate the scene as long as Animation is running.
      */
      virtual void Update();

      /**
      * Is invoked on Past End.
      * @param animationPlayer Animation Player to listen to.
      */

      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);

      void setAnimationListener(Candera::Animation::AnimationPlayerListener* listener);
      bool removeAnimationListener(Candera::Animation::AnimationPlayerListener* listener);

      bool isAnimationEnabled();

      void OnParentViewRenderingEnabled(bool enable);

      /**
      *  Method called whenever parent view is activated/deactivated
      */
      virtual void OnParentViewActivate(bool activate);

      /**
      *  This is a callback function which is called after SetNode is executed.
      */
      virtual void OnNodeChanged();

      template <class TAnimationKeyFrame>
      Candera::UInt32 extractAnimationKeyFrames(Candera::String, TAnimationKeyFrame* data);

      virtual bool CloneFrom(const ControlTemplateCloneableWidget* originalWidget, ControlTemplateMap& controlTemplateMap);

   protected:
      Candera::Node2D* _node;

      Candera::Animation::AnimationTimeDispatcher::SharedPointer _animationTimeDispatcher;
      Candera::Animation::AnimationController::SharedPointer _animationController; // ANIMATION CONTROLLER
      Candera::Animation::SequenceTimeType*	_animationKfsTime;
      Candera::Animation::SequenceTimeType _animationDuration;

      Candera::Float* _animationKfValues;
      Candera::Int32 _componentCount; // Number of values that are assigned to each keyframe.
      Candera::UInt32 _delimeterCount;
      bool _invalidInputData;

      Candera::Animation::AnimationPlayer::SharedPointer _animationPlayer;
      Candera::Animation::AnimationKeyframeSequence::SharedPointer _animationKeyframeSequence;
      Candera::Animation::AnimationBlendedProperty::SharedPointer _animationBlendedProperty;

      bool _shouldRun;              // flag used to start animation
      bool _shouldStop;             // flag used to stop animation

      /**
      * Initialize the Animation before starting it.
      */
      void initAnimation();

      void assignKeyFrameTimeSequence();
      void initAnimationController();
      bool initAnimationProperties();
      void assignAnimationKfSequence();
      void initAnimationPlayer();
      void assignInterpolationStategy();
      bool startAnimation();
      bool stopAnimation();

      void assignKeyFrameValues();

      void postAnimationIndMsg(Candera::Int32 cnt);

      void configureEaseInterpolation(Candera::Animation::EaseInterpolationStrategy::SharedPointer strategy);

      //Cda Properties
      CdaWidget2DDef(AnimationWidget2D, AnimationWidget2DBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaWidgetDefEnd()

   protected:
      /**
      * This function is called when the world time has to be
      * dispatched to a collection of AnimationPlayers present in a widget
      */
      virtual void OnAnimationTimeDispatcherChanged();

      virtual void OnChanged(::Candera::UInt32 propertyId);
};


#endif
