/* ***************************************************************************************
* FILE:          AnimationHelperInterface.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationHelperInterface.h is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _ANIMATION_HELPER_INTERFACE_H
#define _ANIMATION_HELPER_INTERFACE_H

#include <Candera/EngineBase/Animation/AnimationPlayerListener.h>
#include <Widgets/2D/Animation/AnimationBaseHelper.h>

#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <Candera/EngineBase/Animation/AnimationTimeDispatcher.h>
#include <Candera/Engine2D/AnimationPropertySetters/RenderingEnabledNode2DPropertySetter.h>
#include "Candera/Engine2D/Core/RenderNode.h"
#include <vector>
#include <map>

class AnimationElementsContainer
{
   public:
      AnimationElementsContainer() :
         _isAnimationPlaying(false)
      {
         memset(_animationSequenceTime, 0, sizeof(_animationSequenceTime));
         //memset(_animationValues, 0, sizeof(_animationValues));
         _animationValues = 0;
      }

      ~AnimationElementsContainer();

      // functions
      bool stopAllAnimations();
      bool isAnimationPlaying();
      void setAnimationPlaying(bool bStatus);

      Candera::Animation::AnimationPlayer::SharedPointer getAnimationPlayer()
      {
         return _animationPlayer;
      }
      void setAnimationPlayer(Candera::Animation::AnimationPlayer::SharedPointer player)
      {
         _animationPlayer = player;
      }

      const Candera::Animation::AnimationController::SharedPointer& getAnimationController()
      {
         return _animationController;
      }
      void setAnimationController(Candera::Animation::AnimationController::SharedPointer controller)
      {
         _animationController = controller;
      }

      const Candera::Animation::AnimationBlendedProperty::SharedPointer& getAnimationBlendedProperty()
      {
         return _animationBlendedProperty;
      }
      void setAnimationBlendedProperty(Candera::Animation::AnimationBlendedProperty::SharedPointer property)
      {
         _animationBlendedProperty = property;
      }

      const FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence>& getKeyFrameSequence()
      {
         return _nodeRenderingKfs;
      }
      void setKeyFrameSequence(FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> keyFS)
      {
         _nodeRenderingKfs = keyFS;
      }

      // data members
      Candera::Animation::SequenceTimeType                                                      _animationSequenceTime[2];
      FeatStd::Float*                                                                            _animationValues;

   private:
      Candera::Animation::AnimationController::SharedPointer                                               _animationController;
      FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer>             _animationPlayer;
      FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence>   _nodeRenderingKfs;
      Candera::Animation::AnimationBlendedProperty::SharedPointer                               _animationBlendedProperty;
      bool                                                                                      _isAnimationPlaying;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(AnimationElementsContainer);
};


class AnimationHelperInterface : public Candera::Animation::AnimationPlayerListener
{
   public:
      AnimationHelperInterface();

      ~AnimationHelperInterface();

      void startAnimation(Candera::Node2D* pNode, FeatStd::Int32 u32AnimateDuration, const float* animationStartValue, const float* animationEndValue, enAnimationProperty type, Candera::UInt32 repeatCount);

      virtual void OnPastEnd(Candera::Animation::AnimationPlayerBase* animationPlayer, Candera::Int32 completedIterationsCount);

      bool startAnimationAttachedToNode(Candera::Node2D* pNode);

      bool stopAnimation(Candera::Node2D* pNode);

      void stopAllExistingAnimations();

      bool isAnimationOnAnyPlayerRunning();

      bool isAnimationEnabledOnNode(Candera::Node2D* pNode);

      void setTimeDispatcher(Candera::Animation::AnimationTimeDispatcher::SharedPointer pAnimationTimeDispatcher);

   private:

      Candera::Animation::AnimationTimeDispatcher::SharedPointer    _animationTimeDispatcher;
      FeatStd::Internal::Vector <AnimationElementsContainer*>       _vecAnimationPlayers;
      Candera::Int32                                                _componentCount;

      void createAnimationKeyFrameSequence(AnimationElementsContainer* animationElementBlock, FeatStd::UInt32 u32AnimateDuration);

//lint --ffc
      void createAnimationProperties(AnimationElementsContainer* animationElementBlock, Candera::Node2D* pNode, enAnimationProperty type);
//lint ##ffc

      typedef std::map<Candera::Node2D*, AnimationElementsContainer*> NodeAnimationPlayerMap;
      NodeAnimationPlayerMap                                        _nodeAnimationPlayerMap;

      bool isAnyAnimationPlayerFree();

      AnimationElementsContainer* getFreeanimationElementBlock();
};


#endif
