/* ***************************************************************************************
* FILE:          AnimationBaseHelper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationBaseHelper is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(AnimationBaseHelper_H)
#define AnimationBaseHelper_H

#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <Candera/EngineBase/Animation/AnimationTimeDispatcher.h>
#include <Candera/Engine2D/Core/Node2D.h>
#include <Widgets/generated/AllWidgetTypes.h>

class AnimationBaseHelper
{
   public:

      static Candera::Animation::AnimationPlayer::SharedPointer createAnimationPlayer();
      static Candera::Animation::AnimationController::SharedPointer createAnimationController();
      static void setupAnimationPlayer(
         Candera::Animation::AnimationPlayer::SharedPointer& player,
         Candera::Animation::AnimationPlayer::PlayDirection direction,
         Candera::UInt32 repeatCount,
         FeatStd::Float speedFactor,
         FeatStd::Int32 duration);

      static bool addPlayerToAnimationTimeDispatcher(const Candera::Animation::AnimationPlayer::SharedPointer& player, Candera::Animation::AnimationTimeDispatcher::SharedPointer& timeDispatcher);
      static bool removePlayerFromAnimationTimeDispatcher(const Candera::Animation::AnimationPlayer::SharedPointer player, Candera::Animation::AnimationTimeDispatcher::SharedPointer& timeDispatcher);
      static bool addListenerToPlayer(Candera::Animation::AnimationPlayer::SharedPointer& player, Candera::Animation::AnimationPlayerListener* listener);
      static bool removeListenerFromPlayer(Candera::Animation::AnimationPlayer::SharedPointer player, Candera::Animation::AnimationPlayerListener* listener);
      static void setAnimationController(Candera::Animation::AnimationPlayer::SharedPointer& player, const Candera::Animation::AnimationController::SharedPointer& controller);
      static bool addPropertyToAnimationController(Candera::Animation::AnimationController::SharedPointer& controller, const Candera::Animation::AnimationBlendedProperty::SharedPointer& prop);
      static Candera::Animation::AnimationBlendedProperty::SharedPointer createAnimationBlendedProperty();
      static Candera::Animation::AnimationKeyframeSequence::SharedPointer createAnimationKeyFrameSequence();
      static void assignNodeToAnimate(const Candera::Animation::AnimationBlendedProperty::SharedPointer& animationblendedProperty, Candera::Node2D* node);
      static void setInterpolationStrategy(Candera::Animation::InterpolationStrategy::SharedPointer strategy, Candera::Animation::AnimationKeyframeSequence::SharedPointer& animationKfs);
      static void setAnimationSequenceDuration(Candera::Animation::AnimationPlayer::SharedPointer player, Candera::Animation::SequenceTimeType ms);
      static void setAnimationRepeatCount(Candera::Animation::AnimationPlayer::SharedPointer player, Candera::UInt32 repeatCount);
      static bool addKeyframeSequence(Candera::Animation::AnimationBlendedProperty::SharedPointer animationBPS, const FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationKeyframeSequence> animationKFS);

      template <class TPropertySetter>
      static void createPropertySetter(const Candera::Animation::AnimationBlendedProperty::SharedPointer& animationblendedProperty)
      {
         if (!animationblendedProperty.PointsToNull())
         {
            typename TPropertySetter::SharedPointer propertySetter = TPropertySetter::Create();
            animationblendedProperty->SetAnimationPropertySetter(propertySetter);
         }
      }

      template <class TInterpolationStrategy>
      static Candera::Animation::InterpolationStrategy::SharedPointer createInterpolationStrategy()
      {
         Candera::Animation::InterpolationStrategy::SharedPointer strategy = TInterpolationStrategy::Create();
         return strategy;
      }
      static bool createAnimationPropertySetter(const Candera::Animation::AnimationBlendedProperty::SharedPointer& animationblendedProperty, Candera::Node2D* node, enAnimationProperty type);
};


#endif
