/* ***************************************************************************************
* FILE:          Adorner.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Adorner.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "Adorner.h"


#include "hmi_trace_if.h"
#include "hmibase/util/TraceUtils.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/Adorner.cpp.trc.h"
#endif

namespace hmibase {
namespace widget {
namespace adorner {

using ::Candera::Char;//required for CANDERA_RTTI_BASECLASS_DEFINITION
CANDERA_RTTI_BASECLASS_DEFINITION(Adorner)
CANDERA_RTTI_BASECLASS_DEFINITION(AdornerAnimation)


/*****************************************************************************/
Adorner::Adorner() : _sourceWidget(NULL), _node(NULL), _animation(NULL), _visible(false)
{
}


/*****************************************************************************/
Adorner::~Adorner()
{
   _sourceWidget.release();
   _node = NULL;
   _animation = NULL;
}


/*****************************************************************************/
AdornerManager::AdornerManager() : _defaultAnimationDuration(1000)
{
}


/*****************************************************************************/
void AdornerManager::setDefaultMovementCapabilities(const AdornerMovementCapabilities& defaultMovementCapabilities)
{
   _defaultMovementCapabilities = defaultMovementCapabilities;
}


/*****************************************************************************/
const AdornerMovementCapabilities& AdornerManager::getDefaultMovementCapabilities() const
{
   return _defaultMovementCapabilities;
}


/*****************************************************************************/
void AdornerManager::setDefaultAnimationDuration(Candera::Animation::SequenceTimeType defaultAnimationDuration)
{
   _defaultAnimationDuration = defaultAnimationDuration;
}


/*****************************************************************************/
Candera::Animation::SequenceTimeType AdornerManager::getDefaultAnimationDuration() const
{
   return _defaultAnimationDuration;
}


}//adorner
}//widget
}//hmibase
