/* ***************************************************************************************
* FILE:          RegisterWidgetSets.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  RegisterWidgetSets is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "widget2D_std_if.h"
#include "Widgets/WidgetSetCore.h"


Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSetBehaviorsStandard(void);
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSet2DStandard(void);
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSet2DList(void);
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSet2DDeprecated(void);
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSet3DStandard(void);
#ifdef  VARIANT_S_FTR_ENABLE_WIDGETEXT__HANDWRITINGRECOGNITION
Candera::MetaInfo::WidgetSetMetaInfo* GetWidgetSet_WidgetSet2DHandwriting(void);
#endif

void RegisterWidgetSets()
{
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSetBehaviorsStandard());
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSet2DStandard());
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSet2DList());
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSet2DDeprecated());
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSet3DStandard());
#ifdef  VARIANT_S_FTR_ENABLE_WIDGETEXT__HANDWRITINGRECOGNITION
   WidgetSetCore::RegisterWidgetSet(GetWidgetSet_WidgetSet2DHandwriting());
#endif
}
