/* ***************************************************************************************
* FILE:          ImageBehavior.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ImageBehavior is part of HMI-Base Widget Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef _HMIBASE_IMAGE_BEHAVIOR_H_
#define _HMIBASE_IMAGE_BEHAVIOR_H_

#include <Behaviors/Image/generated/ImageBehaviorBase.h>

namespace Candera {
class Image2D;
class BitmapBrush;
}


namespace hmibase {
namespace behavior {
namespace image {

class ImageBehavior2D : public ImageBehaviorBase
{
   public:
      ImageBehavior2D();
      virtual ~ImageBehavior2D();

      void SetImage(::Candera::Behavior& behavior, const ::Candera::MemoryManagement::SharedPointer< ::Candera::Image2D>& image);
      void SetImage(::Candera::Behavior& behavior, ::Candera::BitmapBrush& bitmapBrush, const ::Candera::MemoryManagement::SharedPointer< ::Candera::Image2D>& image);

   protected:
      virtual void Update() override;
      virtual void OnEvent(const ::FeatStd::Event& event, ::Candera::EventDispatchResult& dispatchResult) override;
      virtual void OnChanged(PropertyChangeState state, ::FeatStd::UInt32 propertyId) override;

   private:
      CdaBehavior2DDef(ImageBehavior2D, ImageBehaviorBase)
      CdaProperties()
      CdaPropertiesEnd()
      CdaBehaviorDefEnd()

      bool _invalid;
};


}
}


}

#endif
