/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_VIDEOBUFFER_APXINSTANCE_H
#define HMIBASE_GADGET_VIDEOBUFFER_APXINSTANCE_H

#include <stdint.h>

namespace hmibase {
namespace gadget {
namespace videobuffer {

class ApxContext;

class ApxInstance
{
   public:
      ApxInstance();
      ~ApxInstance();

      int      getFd(uint32_t handle);
      uint32_t getHandle(int fd);

      uint64_t getDumpOffset(uint32_t handle);

      uint32_t createDump(uint16_t width, uint16_t height, uint16_t bpp, uint32_t& size, uint32_t& pitch);
      void     destroyDump(uint32_t handle);

      uint8_t* mapBuffer(uint64_t offset, uint32_t size);
      void     unmapBuffer(void* data, uint32_t size);

   private:
      static int         smApxContextRefCount;
      static ApxContext* smApxContextPtr;

      static void refApxContext();
      static void unrefApxContext();
      static int  getApxFd();
};


} // namespace
} // namespace
} // namespace

#endif
