/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_VIDEOBUFFER_APXCONTEXT_H
#define HMIBASE_GADGET_VIDEOBUFFER_APXCONTEXT_H

#include <stdint.h>

struct wl_display;
struct wl_registry;
struct apx;

namespace hmibase {
namespace gadget {
namespace videobuffer {

class ApxContext
{
   public:
      ApxContext();
      ~ApxContext();

      int getApxFd();

   private:
      int         mApxFd;
      apx*        mApxPtr;
      wl_display* mWlDisplayPtr;

      static void staticCallback(void* dataPtr, wl_registry* wlRegistryPtr, uint32_t name, const char* namePtr, uint32_t version);
      void        objectCallback(wl_registry* wlRegistryPtr, uint32_t name, const char* namePtr, uint32_t version);

      // Thou shalt not copy
      ApxContext(const ApxContext&);
      ApxContext& operator=(const ApxContext&);
};


} // namespace
} // namespace
} // namespace

#endif
