/* ***************************************************************************************
* FILE:          TraceUtils.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraceUtils.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hmibase/util/TraceUtils.h"
#include "hmibase/util/system_if.h"
#ifdef WIN32
#include <Psapi.h>
#else
#include <cstring>
#endif

#include "hmibase/util/Trace.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/TraceUtils.cpp.trc.h"
#endif

namespace hmibase {
namespace trace {
namespace widget {
static unsigned short g_AppWidgetTraceClass = 0;

unsigned short getApplicationTraceClass()
{
   return g_AppWidgetTraceClass;
}


void setUserTraceClass(unsigned short traceclassid)
{
   g_AppWidgetTraceClass = traceclassid;
}


}

TraceUtils* TraceUtils::_theInstance = 0;

std::string getAppName()
{
   return TraceUtils::getInstance().getAppName();
}


TraceUtils& TraceUtils::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new TraceUtils();
   }

   return *_theInstance;
}


TraceUtils::TraceUtils()
{
#ifdef WIN32
   char buffer[300];
   ::GetModuleFileNameA(NULL, buffer, sizeof(buffer));
   if (strlen(buffer) > 2)
   {
      std::string::size_type pos = std::string(buffer).find_last_of("\\/");
      _appName = std::string(buffer).substr(pos + 1);
   }
#else
   FILE* f;
   char file[256] = {0};
   sprintf(file, "/proc/%d/status", getpid());

   f = fopen(file, "r");
   if (f)
   {
      char buf[300];
      while (fgets(buf, sizeof(buf), f) != 0)
      {
         char* s = buf;
         unsigned int len = sizeof(buf);
         while (*s)
         {
            --len;
            (*s == '\t' || *s == ' ' || *s == '\n') ? memmove(s, s + 1, len) : s++;
         }

         if (strncmp(buf, "Name:", 5) == 0)
         {
            //unsigned int len2 = strlen(buf + 5);
            char temp[16];
            memset(temp, 0, sizeof(temp));
            strncpy(temp, buf + 5, sizeof(temp) - 1);

            _appName = buf + 5;
            break;
         }
      }
      fclose(f);
   }
#endif
}


}
}
