/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/SyncObjectImpl.h"
#include "hmibase/util/Error.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#include "trcGenProj/Header/SyncObjectImpl.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace util {

SyncObjectImpl::SyncObjectImpl(const char* name, const bool isMaster, int numBytes)
   : mName(name),
     mNumBytes(numBytes),
     mIsMaster(isMaster),
     mSharedMemoryPtr(NULL)
{
   connect();
}


SyncObjectImpl::~SyncObjectImpl()
{
   disconnect();
}


bool SyncObjectImpl::isConnected()
{
   return mSharedMemoryPtr != NULL && mSharedMemoryPtr->getDataPtr() != NULL;
}


void SyncObjectImpl::connect()
{
   mSharedMemoryPtr = new SharedMemory(mName.cPtr(), mNumBytes, mIsMaster);
   void* memPtr = mSharedMemoryPtr->getDataPtr();

   if (memPtr == NULL)
   {
      disconnect();
      return;
   }

   if (mIsMaster)
   {
      new(memPtr) FixedSizeMutex();
   }
}


void SyncObjectImpl::disconnect()
{
   if (mSharedMemoryPtr != NULL)
   {
      delete mSharedMemoryPtr;
      mSharedMemoryPtr = NULL;
   }
}


FixedSizeMutex* SyncObjectImpl::getMutexPtr()
{
   if (!isConnected())
   {
      return NULL;
   }

   return (FixedSizeMutex*)(mSharedMemoryPtr->getDataPtr());
}


void* SyncObjectImpl::getObjectPtr()
{
   if (!isConnected())
   {
      return NULL;
   }

   char* offsetPtr = (char*)(mSharedMemoryPtr->getDataPtr());
   return offsetPtr + sizeof(FixedSizeMutex);
}


void SyncObjectImpl::lock()
{
   if (!isConnected())
   {
      connect();
   }

   FixedSizeMutex* mutexPtr = getMutexPtr();
   if (mutexPtr != NULL)
   {
      mutexPtr->lock();
   }
}


void SyncObjectImpl::unlock()
{
   FixedSizeMutex* mutexPtr = getMutexPtr();
   if (mutexPtr != NULL)
   {
      mutexPtr->unlock();
   }
}


} // namespace
} // namespace
