/* ***************************************************************************************
* FILE:          StringUtils.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StringUtils.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hmibase/util/StringUtils.h"
#include <stdarg.h>
#include <stdio.h>

namespace hmibase {
namespace util {

int utilsnprintf(char* buffer, size_t buffersize, const char* lpszFormat, ...)
{
   if (buffersize > 0)
   {
      va_list argp;
      va_start(argp, lpszFormat);

      buffer[buffersize - 1] = '\0';
      int n = vsnprintf(buffer, buffersize, lpszFormat, argp);
      va_end(argp);
      if (buffer[buffersize - 1] != '\0')
      {
         //HMI_APP_ASSERT_ALWAYS();
         buffer[buffersize - 1] = '\0';
      }
      return n;
   }
   return 0;
}


std::vector<std::string>& split(const std::string& s, char delim, std::vector<std::string>& elems)
{
   std::stringstream ss(s);
   std::string item;
   while (std::getline(ss, item, delim))
   {
      elems.push_back(item);
   }
   return elems;
}


std::vector<std::string> split(const std::string& s, char delim)
{
   std::vector<std::string> elems;
   split(s, delim, elems);
   return elems;
}


}
}
