/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_UTIL_SIMPLETHREADIMPLPOSIX_H
#define HMIBASE_UTIL_SIMPLETHREADIMPLPOSIX_H
#ifndef WIN32

#include "hmibase/util/SimpleString.h"
#include "hmibase/util/SimpleThreadImpl.h"
#include "hmibase/util/Threadable.h"
#include <pthread.h>

namespace hmibase {
namespace util {

class SimpleThreadImplPosix: public SimpleThreadImpl
{
   public:
      SimpleThreadImplPosix(Threadable& threadable, const SimpleString& name);
      virtual ~SimpleThreadImplPosix();

      virtual bool createThread();
      virtual bool joinThread();
      virtual void sleep(unsigned int milliseconds);

   private:
      pthread_t mThread;
      static void* threadRun(void* selfPtr);

      SimpleString createMessage(const SimpleString& message);
      SimpleString createErrorMessage(const SimpleString& message, int errorCode);
};


} // namespace
} // namespace
#endif // !WIN32
#endif // HMIBASE_UTIL_SIMPLETHREADIMPLPOSIX_H
