/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef WIN32

#include "hmibase/util/Path.h"
#include <sys/stat.h>
#include <dirent.h>

namespace hmibase {
namespace util {


bool Path::isFile() const
{
   struct stat statStruct;
   if (stat(toString().cPtr(), &statStruct) != 0)
   {
      return false;
   }
   return S_ISREG(statStruct.st_mode);
}


bool Path::isDirectory() const
{
   struct stat statStruct;
   if (stat(toString().cPtr(), &statStruct) != 0)
   {
      return false;
   }
   return S_ISDIR(statStruct.st_mode);
}


bool Path::exists() const
{
   struct stat statStruct;
   if (stat(toString().cPtr(), &statStruct) != 0)
   {
      return false;
   }
   return S_ISREG(statStruct.st_mode) || S_ISDIR(statStruct.st_mode);
}


std::set<Path> Path::getChildren() const
{
   std::set<Path> paths;

   DIR* dirPtr = opendir(toString().cPtr());
   if (dirPtr != NULL)
   {
      // Find Elements in Folder
      dirent* direntPtr = readdir(dirPtr);
      while (direntPtr != NULL)
      {
         SimpleString elementName(direntPtr->d_name);

         if (elementName != ""
               && elementName != "."
               && elementName != "..")
         {
            Path path = *this;
            path += elementName;
            paths.insert(path);
         }

         direntPtr = readdir(dirPtr);
      }

      closedir(dirPtr);
   }

   return paths;
}


} // namespace
} // namespace

#endif // !WIN32
