/* ***************************************************************************************
* FILE:          Geometry.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Geometry.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hmibase/util/Geometry.h"

namespace hmibase {
namespace util {
namespace geometry {


Rect::Rect(const Point& pt1, const Size& rSize) :
   ptMin(pt1),
   ptMax(pt1.x + rSize.width - 1, pt1.y + rSize.height - 1)
{
}


bool Rect::intersects(const Rect& rc) const
{
   return ptMin.x <= rc.ptMax.x && ptMax.x >= rc.ptMin.x &&
          ptMin.y <= rc.ptMax.y && ptMax.y >= rc.ptMin.y &&
          !isEmpty() && !rc.isEmpty();
}


void Rect::normalize()
{
   if (ptMin.x > ptMax.x)
   {
      Coord c = ptMax.x;
      ptMax.x = ptMin.x;
      ptMin.x = c;
   }

   if (ptMin.y > ptMax.y)
   {
      Coord c = ptMax.y;
      ptMax.y = ptMin.y;
      ptMin.y = c;
   }
}


void Rect::setBoundingRect(const Rect& rc1, const Rect& rc2)
{
   // check for empty rectangles first
   if (rc1.isEmpty())
   {
      *this = rc2;
   }
   else if (rc2.isEmpty())
   {
      *this = rc1;
   }
   else
   {
      // determine union rectangle
      ptMin.x = (rc1.ptMin.x <= rc2.ptMin.x) ? rc1.ptMin.x : rc2.ptMin.x;
      ptMin.y = (rc1.ptMin.y <= rc2.ptMin.y) ? rc1.ptMin.y : rc2.ptMin.y;
      ptMax.x = (rc1.ptMax.x >= rc2.ptMax.x) ? rc1.ptMax.x : rc2.ptMax.x;
      ptMax.y = (rc1.ptMax.y >= rc2.ptMax.y) ? rc1.ptMax.y : rc2.ptMax.y;
   }
}


void Rect::setIntersection(const Rect& rc1, const Rect& rc2)
{
   // empty rectangles are automatically handled correctly
   ptMin.x = (rc1.ptMin.x >= rc2.ptMin.x) ? rc1.ptMin.x : rc2.ptMin.x;
   ptMin.y = (rc1.ptMin.y >= rc2.ptMin.y) ? rc1.ptMin.y : rc2.ptMin.y;
   ptMax.x = (rc1.ptMax.x <= rc2.ptMax.x) ? rc1.ptMax.x : rc2.ptMax.x;
   ptMax.y = (rc1.ptMax.y <= rc2.ptMax.y) ? rc1.ptMax.y : rc2.ptMax.y;
}


Size Rect::getSize() const
{
   return Size((ptMax.x - ptMin.x) + 1, (ptMax.y - ptMin.y) + 1);
}


Coord Rect::getArea() const
{
   Coord result = 0;
   Coord width = getWidth();
   if (width > 0)
   {
      Coord height = getHeight();
      if (height > 0)
      {
         result = width * height;
      }
   }

   return result;
}


}
}


}
