/* ***************************************************************************************
* FILE:          TestImageRenderer.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TestImageRenderer.h is part of HMI-Base testimagedaemon
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TestImageRenderer_H
#define HMIBASE_TestImageRenderer_H

#include "asf/core/BaseComponent.h"
#include "bosch/cm/ai/hmi/TestImagesStub.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceProxy.h"
#include "ScreenBroker/Client/ClientApi.h"
#include <map>

namespace hmibase {

class WaylandBackend;

class TestImageRenderer :
   public ::asf::core::BaseComponent,
   public ::bosch::cm::ai::hmi::TestImages::TestImagesStub,
   public ScreenBroker::ClientApi

{
   public:

      TestImageRenderer();
      virtual ~TestImageRenderer();

      virtual void onShowTestImageRequest(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::TestImages::ShowTestImageRequest >& request);
      virtual void onActivateTestImageProcessingRequest(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::TestImages::ActivateTestImageProcessingRequest >& request);

      virtual void OnServiceStatusChanged(bool available);

      //
      virtual void OnBuildInLayerInfo(const std::vector<ScreenBroker::BuildInLayerInfo>& info);

   private:
      bool init();
      WaylandBackend* getBackend(uint32_t displayId);
      std::map< uint32_t, WaylandBackend* > _backends;

      bool _isInitialized;
};


}

#endif
