/* ***************************************************************************************
* FILE:          ImageLoaderDevIL.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ImageLoaderDevIL.h is part of HMI-Base testimagedaemon
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_IMAGELOADERDEVIL_H
#define HMIBASE_IMAGELOADERDEVIL_H

#include <stdint.h>
#include <string>

namespace hmibase {
class ImageLoaderDevIL
{
   public:
      enum tenErrorCode
      {
         NO_ERROR = 0,
         UNSUPPORTED_IMAGE_FORMAT,
         CORRUPTED_FILE,
         COULD_NOT_OPEN_FILE,
         INTERNAL_ERROR,
      };

      struct ImageData
      {
         std::string fileName;
         unsigned int imageWidth;
         unsigned int imageHeight;
         unsigned int bpp;
         unsigned int depth;
         unsigned int imageSize;
         uint8_t* buffer;
         tenErrorCode errorCode;

         ImageData(): imageWidth(0), imageHeight(0), bpp(0), depth(0), imageSize(0), buffer(0), errorCode(NO_ERROR)
         {
         }
      };

      ImageLoaderDevIL(const std::string& fileName);
      virtual ~ImageLoaderDevIL();

      void getImageData(ImageData& d) const;

   private:
      void loadImage();

      void handleILError(const char* name);

      unsigned int _handle;

      ImageData _imageData;

      static bool _isILInitialized;
};


}

#endif
