/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SOCKS_MESSAGE_H
#define HMIBASE_GADGET_SYNCBLOCK2_SOCKS_MESSAGE_H

struct msghdr;
struct iovec;

namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {

class Message
{
   public:
      Message(unsigned int dataSize, unsigned int numFds);
      virtual ~Message();

      msghdr* getMsgPtr();

      int   getDataSize() const;
      void* getDataPtr() const;

      int   getNumFds() const;
      int   getFd(int index) const;
      void  setFd(int index, int fd);

   private:
      int     mNumFds;
      int     mDataSize;
      msghdr* mMsgPtr;
      iovec*  mIovecPtr;
      char*   mPayloadPtr;
      int*    mRawFdsPtr;
      char*   mAncillaryPtr;

      int* getFdPtr(int index) const;

      // Thou shalt not copy
      Message(const Message&);
      Message& operator=(const Message&);
};


} // namespace
} // namespace
} // namespace
} // namespace

#endif
