/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/socks/Address.h"
#include <sys/socket.h>
#include <sys/un.h>

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/Address.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {


SimpleString Address::getPath(int key)
{
   return SS::format("/tmp/shared/gadgetsync/Sync_%d", key);
}


sockaddr* Address::getAddress(int key)
{
   return getAddress(getPath(key));
}


sockaddr* Address::getAddress(const SimpleString& path)
{
   sockaddr_un* addressPtr = new sockaddr_un;
   memset(addressPtr, 0, sizeof(sockaddr_un));

   addressPtr->sun_family = AF_UNIX;

   size_t addrLen = sizeof(addressPtr->sun_path) - 1;
   if (path.length() < addrLen)
   {
      addrLen = path.length();
   }
   memcpy(addressPtr->sun_path, path.cPtr(), addrLen);
   addressPtr->sun_path[addrLen] = 0;

   return (sockaddr*) addressPtr;
}


} // namespace
} // namespace
} // namespace
} // namespace
