/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SOCKETPRODUCERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_SOCKETPRODUCERINST_H

#include "hmibase/gadget/syncblock2/ProducerInst.h"
#include "hmibase/util/FixedSizeMutex.h"
#include <list>

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class SocketProducerInst : public ProducerInst
{
   public:
      SocketProducerInst(int key, int instanceId);
      virtual ~SocketProducerInst();

      // Implement ProducerInst
      virtual void startTermination();
      virtual bool isTerminated();
      virtual int  exchange();
      virtual bool onRun(const bool& keepRunning);

   private:
      hmibase::util::FixedSizeMutex mMutex;
      hmibase::util::FixedSizeMutex mExchangeMutex; // Make exchange() thread safe
      int  mCurrentBuffer;
      bool mTerminate;
      std::list<int> mBuffersEmpty;
      std::list<int> mBuffersFilled;
      std::list<int> mBuffersAway;
      std::list<int> mBuffersTerminated;

      bool sendBufferId(int  bufferId);
      bool receiveBufferId(int& bufferId);

      static int smBufferCount;
      static int  popFront(std::list<int>& buffers);
      static int  popBack(std::list<int>& buffers);
      static void moveTo(std::list<int>& buffers, std::list<int>& targetBuffers);
};


} // namespace
} // namespace
} // namespace

#endif
