/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/ShmName.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/ShmName.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

using namespace hmibase::util;

namespace hmibase {
namespace gadget {
namespace syncblock2 {

ShmName::ShmName(int key, int instanceId)
   : mName(SS::format("SyncObject_%d_%d", key, instanceId))
{
}


ShmName::~ShmName()
{
}


const SimpleString& ShmName::getName() const
{
   return mName;
}


} // namespace
} // namespace
} // namespace
