/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SHMCONSUMERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_SHMCONSUMERINST_H

#include "hmibase/gadget/syncblock2/ConsumerInst.h"
#include "hmibase/gadget/syncblock2/BufferStatus.h"
#include "hmibase/gadget/syncblock2/ShmName.h"
#include "hmibase/util/SyncObject.hpp"

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class ShmConsumerInst : public ConsumerInst
{
   public:
      ShmConsumerInst(int key, int instanceId, int fd0, int fd1, int fd2, const BufferInfo& bufferInfo);
      virtual ~ShmConsumerInst();

      int  exchange();
      bool isUpdated();
      void clearUpdatedFlag();
      virtual bool isTerminated();

   private:
      ShmName                  mShmName;
      SyncObject<BufferStatus> mSyncObject;
};


} // namespace
} // namespace
} // namespace

#endif
