/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/ShmConsumerInst.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/ShmConsumerInst.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace syncblock2 {

ShmConsumerInst::ShmConsumerInst(int key, int instanceId, int fd0, int fd1, int fd2, const BufferInfo& bufferInfo)
   : ConsumerInst(key, instanceId, fd0, fd1, fd2, bufferInfo)
   , mShmName(key, instanceId)
   , mSyncObject(mShmName.getName().cPtr(), false)
{
}


ShmConsumerInst::~ShmConsumerInst()
{
   mSyncObject.lock();
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      bsPtr->releaseReadIndex();
      bsPtr->setDirty(false);
   }
   mSyncObject.unlock();
}


int ShmConsumerInst::exchange()
{
   int index = -1;

   mSyncObject.lock();
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      index = bsPtr->getNextReadIndex();
   }
   mSyncObject.unlock();

   if (index < 0 || index > 2)
   {
      return -1;
   }

   return mFds[index];
}


bool ShmConsumerInst::isUpdated()
{
   bool isUpdated = false;

   mSyncObject.lock();
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      isUpdated = bsPtr->isDirty();
   }
   mSyncObject.unlock();

   return isUpdated;
}


void ShmConsumerInst::clearUpdatedFlag()
{
   mSyncObject.lock();
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      bsPtr->setDirty(false);
   }
   mSyncObject.unlock();
}


bool ShmConsumerInst::isTerminated()
{
   bool result = false;

   mSyncObject.lock();
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      result = bsPtr->confirmClose();
   }
   mSyncObject.unlock();

   return result;
}


} // namespace
} // namespace
} // namespace
