/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/ConsumerInst.h"
#include <unistd.h>

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/ConsumerInst.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace syncblock2 {

int ConsumerInst::smObjectCounter = 0;

ConsumerInst::ConsumerInst(int key, int instanceId, int fd0, int fd1, int fd2, const BufferInfo& bufferInfo)
   : mKey(key)
   , mInstanceId(instanceId)
   , mBufferInfo(bufferInfo)
   , mObjectId(0)
{
   smObjectCounter++;
   mObjectId = smObjectCounter;

   mFds[0] = fd0;
   mFds[1] = fd1;
   mFds[2] = fd2;
   ETG_TRACE_USR4_THR(("ConsumerInst[%d][%d][%d]: Constructor", mKey, mInstanceId, mObjectId));
}


ConsumerInst::~ConsumerInst()
{
   ETG_TRACE_USR4_THR(("ConsumerInst[%d][%d][%d]: Closing fds %d %d %d", mKey, mInstanceId, mObjectId, mFds[0], mFds[1], mFds[2]));
   close(mFds[0]);
   close(mFds[1]);
   close(mFds[2]);
   ETG_TRACE_USR4_THR(("ConsumerInst[%d][%d][%d]: Destructor", mKey, mInstanceId, mObjectId));
}


const BufferInfo& ConsumerInst::getBufferInfo() const
{
   return mBufferInfo;
}


} // namespace
} // namespace
} // namespace
