/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_BUFFERSTATUS_H
#define HMIBASE_GADGET_SYNCBLOCK2_BUFFERSTATUS_H

#include "hmibase/util/SimpleString.h"

using namespace hmibase::util;

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class BufferStatus
{
   public:
      BufferStatus();
      virtual ~BufferStatus();

      bool isDirty() const;
      void setDirty(bool value);

      int getNextWriteIndex();
      int getNextReadIndex();

      void releaseReadIndex();
      void requestClose();
      bool confirmClose();

      SimpleString toString() const;

   private:
      enum State
      {
         EMPTY   =  0,
         READING =  1,
         WRITING =  2,
         WRITTEN =  3,
         CLOSING =  4
      };

      static const int smNumBuffers = 3;
      State mStates [smNumBuffers];

      bool meSoooDirty;
};


} // namespace
} // namespace
} // namespace
#endif
