/* ***************************************************************************************
* FILE:          ProjectSettings.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ProjectSettings.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <ScreenBroker/Config.h>
#include "Settings.h"
#include "BaseContract/generated/BaseTypes_SurfaceLayerIds.h"

// ------------------------------------------------------------------------
bool ProjectSettings::IsPermanent(ScreenBroker::UInt32 surfaceId)
{
   return (((static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_PERMANENTSURFACEBASE)      <= surfaceId)
           && (static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_PERMANENTSURFACEBASE_MAX)  >= surfaceId))
          || ((static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_BUILDINSURFACEBASE)      <= surfaceId)
           && (static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_BUILDINSURFACEBASE_MAX)  >= surfaceId)));
}


// ------------------------------------------------------------------------
bool ProjectSettings::IsPopup(ScreenBroker::UInt32 surfaceId)
{
   return (
             ((static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_POPUPBASE)      <= surfaceId)
              && (static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_POPUPBASE_MAX)  >= surfaceId))
          );
}


// ------------------------------------------------------------------------
bool ProjectSettings::DisableInputReceptionOfUnderlyingSurface()
{
   return false;
}


// ------------------------------------------------------------------------
bool ProjectSettings::DisableInputReceptionOfUnderlyingPopup()
{
   return false;
}


// ------------------------------------------------------------------------
void ProjectSettings::GetKeyboardSurfaceConfiguration(ScreenBroker::UInt32& layerId,
      ScreenBroker::UInt32& surfaceId)
{
   layerId = static_cast<ScreenBroker::UInt32>(hmibase::LAYERID_DUMMYKEYHANDLER);
   surfaceId = static_cast<ScreenBroker::UInt32>(hmibase::SURFACEID_DUMMYKEYHANDLER);
}
