/* ***************************************************************************************
* FILE:          WaylandEventHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaylandEventHandler.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(Shared_WaylandEventHandler_h)
#define Shared_WaylandEventHandler_h

#include <Shared/WaylandInc.h>

namespace ScreenBroker {
class WaylandEventHandler
{
   public:
      ///
      static const struct wl_registry_listener* GetRegistryEventHandler();

      ///
      static const struct serverinfo_listener* GetServerInfoListener();

      ///
      static const struct wl_compositor_listener* GetCompositorEventHandler();

      ///
      static const struct wl_seat_listener* GetSeatEventHandler();

      ///
      static const struct wl_keyboard_listener* GetKeyboardEventHandler();

      /// For detailed interface description see Wayland client protocol documentation
      static void RegistryEventGlobal(void* data,
                                      struct wl_registry* registry,
                                      uint32_t name,
                                      const char* interface,
                                      uint32_t version);

      /// For detailed interface description see Wayland client protocol documentation
      static void RegistryEventGlobalRemove(void* data,
                                            struct wl_registry* registry,
                                            uint32_t name);

      ///
      static void ServerInfoEvent(void* data,
                                  struct serverinfo* serverInfo,
                                  uint32_t clientHandle);

      /// For detailed interface description see Wayland client protocol documentation
      static void SeatEventCapabilities(void* data,
                                        struct wl_seat* seat,
                                        uint32_t caps);
      ///
      static void SeatHandleName(void* data,
                                 struct wl_seat* seat,
                                 const char* name);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventKeymap(void* data,
                                      struct wl_keyboard* keyboard,
                                      uint32_t format,
                                      int32_t fd,
                                      uint32_t size);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventEnter(void* data,
                                     struct wl_keyboard* keyboard,
                                     uint32_t serial,
                                     struct wl_surface* surface,
                                     struct wl_array* keys);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventLeave(void* data,
                                     struct wl_keyboard* keyboard,
                                     uint32_t serial,
                                     struct wl_surface* surface);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventKey(void* data,
                                   struct wl_keyboard* keyboard,
                                   uint32_t serial,
                                   uint32_t time,
                                   uint32_t key,
                                   uint32_t state);

      /// For detailed interface description see Wayland client protocol documentation
      static void KeyboardEventModifiers(void* data,
                                         struct wl_keyboard* keyboard,
                                         uint32_t serial,
                                         uint32_t mods_depressed,
                                         uint32_t mods_latched,
                                         uint32_t mods_locked,
                                         uint32_t group);
#if (WAYLAND_VERSION_MAJOR >=1 && WAYLAND_VERSION_MINOR >= 6)
      static void KeyboardHandleRepeatInfo(void* data,
                                           struct wl_keyboard* keyboard,
                                           int32_t rate,
                                           int32_t delay);
};


#endif
}


#endif
