/* ***************************************************************************************
* FILE:          IlmAccessor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IlmAccessor.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_IlmAccessor_h)
#define ScreenBrokerPlugins_Shared_IlmAccessor_h

#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/HorizontalAlignment.h>
#include <ScreenBroker/VerticalAlignment.h>
#include <ScreenBroker/Scaling.h>

#ifndef VARIANT_S_FTR_ENABLE_IVI_SHELL
#include <ilm/ilm_client.h>
#endif

#if !defined(LAYERMANAGER_VERSION_0_9_9)
#include <ilm/ilm_control.h>
#endif

#include <vector>

struct wl_surface;
struct wl_egl_window;

namespace ScreenBroker {
class WaylandContext;

///
class IlmAccessor
{
   public:
      ///
      static bool Commit(ilmErrorTypes& ilmError);

      ///
      static bool SetLayerRenderOrder(UInt32 displayId,
                                      UInt32* layerArray,
                                      UInt32 layerCount,
                                      bool commit,
                                      ilmErrorTypes& ilmError);

      ///
      static bool CreateSurface(wl_surface*& surface,
                                wl_egl_window* const& eglWindow,
                                WaylandContext& context,
                                UInt32 surfaceId,
                                t_ilm_int width,
                                t_ilm_int height,
                                bool commit,
                                ilmErrorTypes& ilmError);

      ///
      static bool AddSurfaceToLayer(UInt32 layerId,
                                    UInt32 surfaceId,
                                    bool commit,
                                    ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceRenderOrder(UInt32 layerId,
                                        t_ilm_layer renderOrder[],
                                        t_ilm_int count,
                                        bool commit,
                                        ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceSourceRectangle(UInt32 surfaceId,
                                            t_ilm_int posX,
                                            t_ilm_int posY,
                                            t_ilm_int width,
                                            t_ilm_int height,
                                            bool commit,
                                            ilmErrorTypes& ilmError);

      ///
      static bool GetSurfaceSourceRectangle(UInt32 surfaceId,
                                            t_ilm_int& posX,
                                            t_ilm_int& posY,
                                            t_ilm_int& width,
                                            t_ilm_int& height,
                                            ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceDestinationRectangle(UInt32 surfaceId,
            t_ilm_int posX,
            t_ilm_int posY,
            t_ilm_int width,
            t_ilm_int height,
            bool commit,
            ilmErrorTypes& ilmError);

      ///
      static bool GetSurfaceDestinationRectangle(UInt32 surfaceId,
            t_ilm_int& posX,
            t_ilm_int& posY,
            t_ilm_int& width,
            t_ilm_int& height,
            ilmErrorTypes& ilmError);
      ///
      static bool SetSurfaceRectangle(UInt32 surfaceId,
                                      t_ilm_int posX,
                                      t_ilm_int posY,
                                      t_ilm_int width,
                                      t_ilm_int height,
                                      bool commit,
                                      ilmErrorTypes& ilmError);

      ///
      static bool SetSurfacePosition(UInt32 surfaceId,
                                     t_ilm_uint posX,
                                     t_ilm_uint posY,
                                     bool commit,
                                     ilmErrorTypes& ilmError);

      ///
      static bool GetSurfacePosition(UInt32 surfaceId,
                                     t_ilm_uint& posX,
                                     t_ilm_uint& posY,
                                     ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceDimension(UInt32 surfaceId,
                                      t_ilm_uint width,
                                      t_ilm_uint height,
                                      bool commit,
                                      ilmErrorTypes& ilmError);

      static bool GetSurfaceDimension(UInt32 surfaceId,
                                      t_ilm_uint& width,
                                      t_ilm_uint& height,
                                      ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceOpacity(UInt32 surfaceId,
                                    t_ilm_float opacity,
                                    bool commit,
                                    ilmErrorTypes& ilmError);

      static bool GetSurfaceOpacity(UInt32 surfaceId,
                                    t_ilm_float& opacity,
                                    ilmErrorTypes& ilmError);

      ///
      static bool SetSurfaceVisibility(UInt32 surfaceId,
                                       t_ilm_bool visible,
                                       bool commit,
                                       ilmErrorTypes& ilmError);

      ///
      static bool GetSurfaceVisibility(UInt32 surfaceId,
                                       t_ilm_bool& visible,
                                       ilmErrorTypes& ilmError);

      ///
      static bool SwitchSurfaceVisibility(UInt32 oldSurfaceId,
                                          t_ilm_bool oldVisible,
                                          UInt32 newSurfaceId,
                                          t_ilm_bool newVisible,
                                          bool commit,
                                          ilmErrorTypes& ilmError);

      ///
      static bool ScaleSurfaceToLayer(UInt32 layerId,
                                      UInt32 surfaceId,
                                      bool commit,
                                      ilmErrorTypes& ilmError);
      ///
      static bool SetLayerRectangle(UInt32 layerId,
                                    t_ilm_int posX,
                                    t_ilm_int posY,
                                    t_ilm_int width,
                                    t_ilm_int height,
                                    bool commit,
                                    ilmErrorTypes& ilmError);
      ///
      static bool GetLayerRectangle(UInt32 layerId,
                                    t_ilm_int& posX,
                                    t_ilm_int& posY,
                                    t_ilm_int& width,
                                    t_ilm_int& height,
                                    ilmErrorTypes& ilmError);

      ///
      static bool SetLayerSourceRectangle(UInt32 layerId,
                                          t_ilm_int posX,
                                          t_ilm_int posY,
                                          t_ilm_int width,
                                          t_ilm_int height,
                                          bool commit,
                                          ilmErrorTypes& ilmError);

      ///
      static bool SetLayerDestinationRectangle(UInt32 layerId,
            t_ilm_int posX,
            t_ilm_int posY,
            t_ilm_int width,
            t_ilm_int height,
            bool commit,
            ilmErrorTypes& ilmError);

      ///
      static bool SetLayerOpacity(UInt32 layerId,
                                  t_ilm_float opacity,
                                  bool commit,
                                  ilmErrorTypes& ilmError);

      ///
      static bool SetLayerVisibility(UInt32 layerId,
                                     t_ilm_bool visibility,
                                     bool commit,
                                     ilmErrorTypes& ilmError);

      ///
      static bool GetLayerProperties(UInt32 layerId,
                                     t_ilm_int& posX,
                                     t_ilm_int& posY,
                                     t_ilm_int& width,
                                     t_ilm_int& height,
                                     t_ilm_bool& visibility,
                                     t_ilm_float& opacity,
                                     ilmErrorTypes& ilmError);

      ///
      static bool SetKeyboardFocus(UInt32 surfaceId,
                                   bool commit,
                                   ilmErrorTypes& ilmError);

      ///
      static UInt32 GetKeyboardFocus();

      ///
      static bool HasKeyboardFocus(UInt32 surfaceId);
      static bool SetPointerFocus(UInt32 surfaceId,
                                  bool commit,
                                  ilmErrorTypes& ilmError);

      ///
      static UInt32 GetPointerFocus();

      static bool HasPointerFocus(UInt32 surfaceId);

      ///
      static bool AcceptInputEvents(UInt32 surfaceId,
                                    ilmInputDevice inputDevices,
                                    t_ilm_bool activate,
                                    bool commit,
                                    ilmErrorTypes& ilmError);

      ///
      static ilmInputDevice GetInputAcceptance(UInt32 surfaceId);

      ///
      static bool SetIntputAcceptanceOn(UInt32 surfaceId,
                                        t_ilm_uint NumberSeats,
                                        t_ilm_string* seats);
      static bool UpdateAppearance(UInt32 layerId,
                                   UInt32 surfaceId,
                                   Scaling::Enum scaling,
                                   HorizontalAlignment::Enum horizontalAlignment,
                                   VerticalAlignment::Enum verticalAlignment,
                                   bool commit,
                                   ilmErrorTypes& ilmError);

      ///
      static void TestInputAcceptance(UInt32 surfaceId);

      //
      static void GetScreenIds(std::vector<UInt32>& ids);

      //
      static bool GetScreenDimensions(UInt32 screenId,
                                      t_ilm_uint& width,
                                      t_ilm_uint& height,
                                      ilmErrorTypes& ilmError);

      //
      static bool isLayerAvailable(UInt32 layerId);

      //
      static UInt32 getAttachedSurfaceCount(UInt32 layerId);

      //
      static bool removeAllAttachedSurfaces(UInt32 layerId);
};


}

#endif
