/* ***************************************************************************************
* FILE:          FocusList.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusList.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "ActiveSurfaces.h"
#include "IlmAccessor.h"

#include <ScreenBrokerSettings/Settings.h>
#include <algorithm>
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_PLUGINS
#include "trcGenProj/Header/FocusList.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(LogRealm::Focus);

// ------------------------------------------------------------------------
UInt32 FocusList::SetFocus(UInt32 surfaceId)
{
   UInt32 lPrevSurfaceId = GetFocus();
   Remove(surfaceId);
   mFocusList.push_back(surfaceId);

   return lPrevSurfaceId;
}


// ------------------------------------------------------------------------
UInt32 FocusList::GetFocus() const
{
   UInt32 lSurfaceId = 0;

   if (!mFocusList.empty())
   {
      lSurfaceId = mFocusList.back();
   }

   return lSurfaceId;
}


// ------------------------------------------------------------------------
UInt32 FocusList::Remove(UInt32 surfaceId)
{
   for (SurfaceList::iterator it = mFocusList.begin(); mFocusList.end() != it; ++it)
   {
      if ((*it) == surfaceId)
      {
         mIt = mFocusList.erase(it);
         return (*mIt);
      }
   }
   return 0;
}


// ------------------------------------------------------------------------
void FocusList::PushBack(UInt32 surfaceId)
{
   mFocusList.push_back(surfaceId);
}


// ------------------------------------------------------------------------
UInt32 FocusList::GetFirst()
{
   mIt = mFocusList.begin();
   return (mFocusList.end() != mIt) ? (*mIt) : 0;
}


// ------------------------------------------------------------------------
UInt32 FocusList::GetNext()
{
   if (mFocusList.end() != mIt)
   {
      ++mIt;
   }

   return (mFocusList.end() != mIt) ? (*mIt) : 0;
}


// ------------------------------------------------------------------------
UInt32 FocusList::Size() const
{
   return UInt32(mFocusList.size());
}


// ------------------------------------------------------------------------
void FocusList::Reset()
{
   mFocusList.clear();
   mIt = mFocusList.begin();
}


// ------------------------------------------------------------------------
void FocusList::Dump() const
{
   UInt32 i = 0;
   for (SurfaceList::const_iterator it = mFocusList.begin(); mFocusList.end() != it; ++it)
   {
      ++i;
      UInt32 lSurfaceId = (*it);
      ETG_TRACE_USR1(("&   %d. surface: %u",
                      i,
                      lSurfaceId));
   }
}


}
