/* ***************************************************************************************
* FILE:          AnimationHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationHandler.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_AnimationHandler_h)
#define ScreenBrokerPlugins_Shared_AnimationHandler_h

#include <Base.h>
#include <Shared/Animation/AnimationType.h>
#include <Shared/Animation/AnimationProperties.h>
#include <list>
#include <map>

namespace ScreenBroker {
class AnimationBase;
class AnimationSurfacePropertiesBase;
class AnimationUserData;


namespace AnimationMethod {
enum Enum
{
   Disabled = 0,
   Sequential = 1,
   Parallel = 2
};


}

namespace AnimationCategory {
enum Enum
{
   Simple = 0,
   Complex
};


}

namespace AnimationStatus {
enum Enum
{
   Undefined = 0,
   Started,
   InProgress,
   Stopped
};


}

///
class AnimationHandler
{
   public:
      ///
      static bool EstablishAnimation(AnimationDirection::Enum animationDirection,
                                     UInt32 surfaceId,
                                     const AnimationUserData& animationUserData,
                                     AnimationType::Enum animationType);

      ///
      static bool EstablishLayerAnimation(AnimationDirection::Enum animationDirection,
                                          UInt32 layerId,
                                          const AnimationUserData& animationUserData,
                                          AnimationType::Enum animationType);
      ///
      static void TriggerAnimations(bool commit = true);

      ///
      static void AbortAnimations(UInt32 surfaceId = 0);

      ///
      static void ObtainCriticalSection();

      ///
      static void ReleaseCriticalSection();

      ///
      static bool IsCancelled();
   private:
      typedef std::list<AnimationBase*> AnimatorList;

      static AnimatorList mAnimationQueue;
      static AnimatorList mAnimatorList;

      //For Simple animation
      static AnimationBase* mCurrentAnimation;
      static bool mCancel;
      static AnimationMethod::Enum _CurrentAnimationMethod;
      static bool _isAnimationMethodRead;

      ///
      static bool mAnimationMethod;
      static void OnAnimationFinished(const AnimationSurfacePropertiesBase& surfaceProperties,
                                      bool triggerNext);
      static void OnLayerAnimationFinished(const AnimationSurfacePropertiesBase& surfaceProperties,
                                           bool triggerNext);
      static bool isInAnimatorList(UInt32 surfaceId);
      static void removeAnimationData(UInt32 surfaceId);
      static void cancelAnimation(UInt32 surfaceId);
      static void popOutAnimationQueue(UInt32 surfaceId);
      static AnimationMethod::Enum GetAnimationMethod();
};


}

#endif
