/* ***************************************************************************************
* FILE:          SlidingAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SlidingAnimation.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// intented hiding of base class member
//lint -esym(1516, *::Base) "Member declaration hides inherited member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Animation_SlidingAnimation_h)
#define ScreenBrokerPlugins_Shared_Animation_SlidingAnimation_h

#include <Shared/Animation/Animation.h>
#include <Shared/Animation/Rectangle.h>

namespace ScreenBroker {
typedef AnimationSurfaceProperties<Rectangle> SlidingAnimationSurfaceProperties;

///
class SlidingAnimation: public Animation<SlidingAnimationSurfaceProperties>
{
      typedef Animation<SlidingAnimationSurfaceProperties> Base;

   public:
      SlidingAnimation() : Base() {}

   protected:
      virtual bool InitializeSurfaceState(SlidingAnimationSurfaceProperties& surfaceProperties, bool commit);
      virtual bool UpdateSurfaceState(const SlidingAnimationSurfaceProperties& surfaceProperties,
                                      UInt32 count,
                                      bool commit);
      virtual bool SetFinalSurfaceState(const SlidingAnimationSurfaceProperties& surfaceProperties, bool commit);
};


}

#endif
