/* ***************************************************************************************
* FILE:          QuadEaseInterpolationStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  QuadEaseInterpolationStrategy.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "QuadEaseInterpolationStrategy.h"

namespace ScreenBroker {
// ------------------------------------------------------------------------
Float QuadEaseInterpolationStrategy::EaseIn(Float t, Float b, Float c, Float d)
{
   t /= d;
   return c * t * t + b;
}


// ------------------------------------------------------------------------
Float QuadEaseInterpolationStrategy::EaseOut(Float t, Float b, Float c, Float d)
{
   t /= d;
   return -c * t * (t - 2.0F) + b;
}


// ------------------------------------------------------------------------
Float QuadEaseInterpolationStrategy::EaseInOut(Float t, Float b, Float c, Float d)
{
   t /= (d / 2.0F);
   if (t < 1.0F)
   {
      return (c / 2.0F) * t * t + b;
   }

   t--;
   return (-c / 2.0F) * (t * (t - 2.0F) - 1.0F) + b;
}


}
