/* ***************************************************************************************
* FILE:          InterpolationStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  InterpolationStrategy.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBrokerPlugins_Shared_Interpolation_InterpolationStrategy_h)
#define ScreenBrokerPlugins_Shared_Interpolation_InterpolationStrategy_h

#include <ScreenBroker/Types.h>
#include <Shared/Animation/AccelerationType.h>
#include <Shared/Animation/InterpolationPool.h>

namespace ScreenBroker {
class InterpolationStrategy
{
   public:
      InterpolationStrategy();
      virtual ~InterpolationStrategy();

      virtual Float Interpolate(UInt32 steps, Float start, Float end, UInt32 count) = 0;

      Float GetAmplitude() const
      {
         return mAmplitude;
      }
      void SetAmplitude(Float amplitude);

      void Reset();

      void SetPool(InterpolationPoolBase* interpolationPool);

      virtual void Release();

   private:
      InterpolationPoolBase* mPool;
      Float mAmplitude;
};


}

#endif
