/* ***************************************************************************************
* FILE:          InterpolationStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  InterpolationStrategy.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "InterpolationStrategy.h"

namespace ScreenBroker {
// ------------------------------------------------------------------------
InterpolationStrategy::InterpolationStrategy() :
   mPool(0),
   mAmplitude(1.0F)
{
   // nothing to do
}


// ------------------------------------------------------------------------
InterpolationStrategy::~InterpolationStrategy()
{
   mPool = 0;
}


// ------------------------------------------------------------------------
void InterpolationStrategy::SetAmplitude(Float amplitude)
{
   if (amplitude >= 99.99F)
   {
      mAmplitude = 99.99F;
   }
   else if (amplitude < -1.0F)
   {
      mAmplitude = -1.0F;
   }
   else
   {
      mAmplitude = amplitude;
   }
}


// ------------------------------------------------------------------------
void InterpolationStrategy::Reset()
{
   mPool = 0;
}


// ------------------------------------------------------------------------
void InterpolationStrategy::SetPool(InterpolationPoolBase* interpolationPool)
{
   mPool = interpolationPool;
}


// ------------------------------------------------------------------------
void InterpolationStrategy::Release()
{
   if (mPool != 0)
   {
      mPool->ReturnInterpolation(this);
   }
}


}
