/* ***************************************************************************************
* FILE:          InterpolationFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  InterpolationFactory.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBrokerPlugins_Shared_Interpolation_InterpolationFactory_h)
#define ScreenBrokerPlugins_Shared_Interpolation_InterpolationFactory_h

#include <Shared/Animation/AccelerationType.h>
#include <Shared/Animation/InterpolationStrategy.h>

namespace ScreenBroker {
class InterpolationFactory
{
   public:
      static const UInt32 cMaxInterpolations = 6;

      static InterpolationStrategy* Create(AccelerationType::Enum acceleration);

   private:
      static InterpolationStrategy* CreateLinearInterpolationStrategy();
      static InterpolationStrategy* CreateInQuadInterpolationStrategy();
      static InterpolationStrategy* CreateOutQuadInterpolationStrategy();
      static InterpolationStrategy* CreateOutBounceInterpolationStrategy();
};


}

#endif
