/* ***************************************************************************************
* FILE:          EaseInterpolationStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EaseInterpolationStrategy.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBrokerPlugins_Shared_Interpolation_EaseInterpolationStrategy_h)
#define ScreenBrokerPlugins_Shared_Interpolation_EaseInterpolationStrategy_h

#include <Shared/Animation/InterpolationStrategy.h>

namespace ScreenBroker {
namespace EaseDirection {
enum Enum
{
   EaseIn,
   EaseOut,
   EaseInOut
};


}

class EaseInterpolationStrategy : public InterpolationStrategy
{
   public:
      EaseInterpolationStrategy();
      virtual ~EaseInterpolationStrategy() { }

      EaseDirection::Enum GetEaseDirection() const
      {
         return mEaseDirection;
      }
      void SetEaseDirection(EaseDirection::Enum easeDirection)
      {
         mEaseDirection = easeDirection;
      }

      virtual Float Interpolate(UInt32 steps, Float start, Float end, UInt32 count);

   protected:
      virtual Float EaseIn(Float t, Float b, Float c, Float d) = 0;
      virtual Float EaseOut(Float t, Float b, Float c, Float d) = 0;
      virtual Float EaseInOut(Float t, Float b, Float c, Float d) = 0;

   private:
      EaseDirection::Enum mEaseDirection;
};


}

#endif
