/* ***************************************************************************************
* FILE:          EaseInterpolationStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  EaseInterpolationStrategy.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "EaseInterpolationStrategy.h"

namespace ScreenBroker {
// ------------------------------------------------------------------------
EaseInterpolationStrategy::EaseInterpolationStrategy() :
   mEaseDirection(EaseDirection::EaseIn)
{
}


// ------------------------------------------------------------------------
Float EaseInterpolationStrategy::Interpolate(UInt32 steps, Float start, Float end, UInt32 count)
{
   Float retVal = 0.0F;

   switch (mEaseDirection)
   {
      case EaseDirection::EaseIn:
         retVal = EaseIn(Float(Float(count) / Float(steps)), start, end - start, 1.0F);
         break;
      case EaseDirection::EaseOut:
         retVal = EaseOut(Float(Float(count) / Float(steps)), start, end - start, 1.0F);
         break;
      case EaseDirection::EaseInOut:
         retVal = EaseInOut(Float(Float(count) / Float(steps)), start, end - start, 1.0F);
         break;
      default:
         // nothing to do
         break;
   }

   return retVal;
}


}
