/* ***************************************************************************************
* FILE:          BounceEaseInterpolationStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BounceEaseInterpolationStrategy.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "BounceEaseInterpolationStrategy.h"

namespace ScreenBroker {
// ------------------------------------------------------------------------
Float BounceEaseInterpolationStrategy::EaseIn(Float t, Float b, Float c, Float d)
{
   return (c - EaseOut(d - t, 0.0F, c, d)) + b;
}


// ------------------------------------------------------------------------
Float BounceEaseInterpolationStrategy::EaseOut(Float t, Float b, Float c, Float d)
{
   Float retVal;

   t /= d;

   if (t < (1.0F / 2.75F))
   {
      retVal = c * (7.5625F * t * t) + b;
   }
   else if (t < (2.0F / 2.75F))
   {
      t -= (1.5F / 2.75F);
      retVal = c * (7.5625F * t * t * GetAmplitude() + ((-0.25F * GetAmplitude()) + 1.0F)) + b;
   }
   else if (t < (2.5F / 2.75F))
   {
      t -= (2.25F / 2.75F);
      retVal = c * (7.5625F * t * t * GetAmplitude() + ((-0.0625F * GetAmplitude()) + 1.0F)) + b;
   }
   else
   {
      t -= (2.625F / 2.75F);
      retVal = c * (7.5625F * t * t * GetAmplitude() + ((-0.015625F * GetAmplitude()) + 1.0F)) + b;
   }
   return retVal;
}


// ------------------------------------------------------------------------
Float BounceEaseInterpolationStrategy::EaseInOut(Float t, Float b, Float c, Float d)
{
   if (t < (d / 2.0F))
   {
      return EaseIn(t * 2.0F, 0.0F, c, d) * 0.5F + b;
   }

   return (EaseOut((t * 2.0F) - d, 0.0F, c, d) * 0.5F) + (c * 0.5F) + b;
}


}
