/* ***************************************************************************************
* FILE:          AnimationUserData.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationUserData.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_Animation_AnimationUserData_h)
#define ScreenBrokerPlugins_Shared_Animation_AnimationUserData_h

#include <Base.h>
#include <ScreenBroker/SurfaceState.h>

namespace ScreenBroker {
struct AnimationUserData
{
   UInt32 userData;
   SurfaceState::Enum surfaceState;
   bool sendNotification;
   bool visibility;

   AnimationUserData() :
      userData(0),
      surfaceState(SurfaceState::Registered),
      sendNotification(true),
      visibility(true)
   {}

   AnimationUserData(UInt32 aUserData,
                     SurfaceState::Enum aSurfaceState,
                     bool aSendNotification,
                     bool aVisibility) :
      userData(aUserData),
      surfaceState(aSurfaceState),
      sendNotification(aSendNotification),
      visibility(aVisibility)
   {}
};


}

#endif
