/* ***************************************************************************************
* FILE:          ActiveSurfaces.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ActiveSurfaces.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_ActiveSurfaces_h)
#define ScreenBrokerPlugins_Shared_ActiveSurfaces_h

#include "FocusList.h"
#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/Plugin/IScreenBrokerPlugin.h>
#include <list>
#include <map>

namespace ScreenBroker {
///
class ActiveSurfaces
{
   public:
      ///
      static ActiveSurfaces& GetInstance();

      ///
      ActiveSurfaces();

      ///
      UInt32 Remove(UInt32 surfaceId);

      ///
      UInt32 PutOnTop(UInt32 surfaceId, UInt32 userData, UInt32 appId);

      ///
      UInt32 GetTop(UInt32 displayId, bool ignorePermanentSurfaces = true) const;

      ///
      bool Exists(UInt32 surfaceId) const;

      ///
      UInt32 GetUserData(UInt32 surfaceId) const;

      ///
      UInt32 GetAppId(UInt32 surfaceId) const;

      ///
      UInt32 GetFirst(UInt32 displayId, bool ignorePermanentSurfaces = true);

      ///
      UInt32 GetNext(UInt32 displayId, bool ignorePermanentSurfaces = true);

      ///
      void Dump();

      /**
       * @brief Completely reset the internal states.
       */
      void Reset();

   private:
      ///
      class Properties
      {
         public:
            Properties(UInt32 userData = 0, UInt32 appId = 0) : mUserData(userData), mAppId(appId) {}
            UInt32 UserData() const
            {
               return mUserData;
            }
            UInt32 AppId() const
            {
               return mAppId;
            }
         private:
            UInt32 mUserData;
            UInt32 mAppId;
      };

      typedef std::list<UInt32> ActiveSurfaceList;
      typedef std::map<UInt32, ActiveSurfaceList> ActiveSurfaceMap;
      typedef std::map<UInt32, Properties> SurfacePropertiesMap;

      ActiveSurfaceMap mActiveSurfaceMap;
      SurfacePropertiesMap mSurfacePropertiesMap;
      ActiveSurfaceList::const_iterator mIt;

      ///
      const Properties* GetProperties(UInt32 surfaceId) const;
};


}

#endif
