/* ***************************************************************************************
* FILE:          ScreenBrokerActivator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScreenBrokerActivator.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
//lint -esym(1511, ScreenBroker::IScreenBrokerPlugin::Create) "static member can't be made virtual"
// This class is intended to be a singleton, for this reason it is ok, that the
// constructor has only private access.
//lint -esym(1704, ScreenBroker::ScreenBrokerActivator::ScreenBrokerActivator)
//"Constructor has private access specification"
// =============================================================================

#if !defined(ScreenBrokerPlugins_ScreenBrokerActivator_ScreenBrokerActivator_h)
#define ScreenBrokerPlugins_ScreenBrokerActivator_ScreenBrokerActivator_h

#include <ScreenBroker/Plugin/IScreenBrokerActivator.h>
#include <ScreenBroker/Service/ServiceRequestArg.h>

namespace ScreenBroker {

///
class ScreenBrokerActivator : public IScreenBrokerActivator
{
   public:
      ///
      static IScreenBrokerPlugin& Create();

      ///
      virtual ~ScreenBrokerActivator();

      ///
      virtual bool Init();

      ///
      virtual void Reset();

      ///
      virtual void Diagnosis();

      ///
      virtual void Test();

      ///
      virtual void Activate(const ServiceRequestArg& serviceRequestArg,
                            UInt32 layerId,
                            UInt32 surfaceId,
                            UInt32 entryCustomAnimationType,
                            UInt32 exitCustomAnimationType,
                            UInt32 hint);

      ///
      virtual void TransitionAnimation(const ServiceRequestArg& serviceRequestArg,
                                       UInt32 layerId,
                                       UInt32 surfaceId,
                                       UInt32 animationType,
                                       UInt32 hint);
      ///
      virtual void TransitionAnimationOfLayer(const ServiceRequestArg& serviceRequestArg,
                                              UInt32 layerId,
                                              std::vector<UInt32> surfaceIdList,
                                              UInt32 animationType,
                                              UInt32 hint);
      ///
      virtual void SetInputFocus(UInt32 surfaceId,
                                 bool keyboardFocus,
                                 bool pointerFocus,
                                 Int32 priority,
                                 UInt32 focusData);

      ///
      virtual void DeregisterSurface(UInt32 surfaceId);

      ///
      virtual DimensionArg GetPreferredDimensions(const ServiceRequestArg& serviceRequestArg,
            UInt32 layerId,
            const DimensionArg& defaultDimension);

      ///
      virtual void Action(UInt32 actionId, UInt32 actionData);

      ///
      virtual void RequestCurrentStatus(UInt32 requestId);

   private:
      ///
      ScreenBrokerActivator();

      ///
      static bool ActivationPostProcessing(UInt32 surfaceId,
                                           bool showSurface,
                                           UInt32 userData,
                                           UInt32 appId,
                                           UInt32 exitCustomAnimation,
                                           UInt32 entryCustomAnimation);
};


}

#endif
