/* ***************************************************************************************
* FILE:          Base.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Base.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Base_h)
#define ScreenBrokerPlugins_Base_h

#include <Version.h>
#include <ScreenBrokerSettings/Settings.h>


/** Macro for stringize */
#define __SBPLUGINS_STRINGIZE__(x) #x
#define SBPLUGINS_STRINGIZE(x) __SBPLUGINS_STRINGIZE__(x)

#define PLUGIN(plugin) dynamic_cast<ScreenBroker::plugin *>(ServiceApi::plugin())

namespace ScreenBroker {
/**
 * @brief Checks the plugins version for compatibility against screenbroker version.
 * @return True if compatible, false otherwise.
 */
bool VersionCheck();
}


#endif
