/* ***************************************************************************************
* FILE:          Base.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Base.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "Base.h"
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKERSERVICE
#include "trcGenProj/Header/Base.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(LogRealm::PluginManager);

// -----------------------------------------------------------------------------
bool VersionCheck()
{
   static bool lVersionChecked = false;
   static bool lRc = false;

   if (!lVersionChecked)
   {
      lVersionChecked = true;

      // Major version must always be equal
      lRc = (SCREENBROKERPLUGINS_MAJOR_VERSION == SCREENBROKER_MAJOR_VERSION);

      // Minor version shall always be equal, except screen broker plugins provide backward compatibility
      if (lRc)
      {
         lRc = (SCREENBROKERPLUGINS_MINOR_VERSION == SCREENBROKER_MINOR_VERSION);

         // Added exceptions due to backward compatibility provided via
         if (!lRc)
         {
            // Example: lRc = lRc || <add_here_a_backward_compatibility_version_rule>
            ETG_TRACE_FATAL(("Plugins (v%40s) are incompatible to screen broker (v%40s)!",
                             SCREENBROKERPLUGINS_VERSION_STRING, SCREENBROKER_VERSION_STRING));
         }
         else
         {
            ETG_TRACE_SYS(("Plugins (v%40s) running in compatibility mode to screen broker (v%40s)!",
                           SCREENBROKERPLUGINS_VERSION_STRING, SCREENBROKER_VERSION_STRING));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("Plugins (v%40s) are incompatible to screen broker (v%40s)! Different major version number!",
                          SCREENBROKERPLUGINS_VERSION_STRING, SCREENBROKER_VERSION_STRING));
      }
   }

   // Patch and tweak level are consequently ignored (no interface change)
   return lRc;
}


}
